"use client"

import { cn } from "@/lib/utils";
import { ComponentWithClassName } from "@/types/utils";
import { getCoreRowModel, RowData, TableOptions, useReactTable } from "@tanstack/react-table";
import { Table, TableBody, TableCell, TableRow } from "@/components/ui/table";
import { WorkflowButtonInvite } from "./workflow.button-invite";
import { FadeIn } from "@/components/animations/fade-in";
import { Skeleton } from "@/components/ui/skeleton";

const INTERNAL__BASE_FADE_IN_DELAY = 0.00;

export function UsersTableLoading<TData extends RowData>({
  className,
  columns,
  rowCount = 5,
}: ComponentWithClassName<{
  columns: TableOptions<TData>["columns"],
  rowCount?: number,
}>) {
  const table = useReactTable({
    data: [],
    columns,
    getCoreRowModel: getCoreRowModel(),
    enableSorting: false,
    enableColumnFilters: false,
    enableColumnPinning: false,
    enableColumnResizing: false,
    enableExpanding: false,
    enableFilters: false,
    enableGlobalFilter: false,
    enableGrouping: false,
    enableHiding: false,
    enableMultiRemove: false,
    enableMultiRowSelection: false,
    enableMultiSort: false,
    enableRowPinning: false,
    enableRowSelection: false,
    enableSortingRemoval: false,
    enableSubRowSelection: false,
    enablePinning: false,
  })
  const headerGroups = table.getHeaderGroups();
  const columnCount = headerGroups.reduce<number>((total, current) => total + current.headers.length, 0);
  return (
    <div className={cn("flex flex-col gap-0", className)}>
      <div className="grid gap-8">
        <div className={"overflow-x-auto"}>
          <div>
            <div className="rounded-md border">
              <Table>
                <TableBody>
                  {rowCount > 0 ? (
                    <>
                      {
                        [...Array.from(Array(rowCount))].map((_, i) => (
                          <TableRow
                            key={i}
                            className="[&>td:first-child]:pl-6"
                          >
                            {[...Array.from(Array(columnCount))].map((_, ii) => (
                              <TableCell
                                key={ii}
                                className="py-4 [&:nth-child(2)]:pl-4 last-of-type:max-w-none bg-background"
                              >
                                <FadeIn delay={INTERNAL__BASE_FADE_IN_DELAY + (0.05 * (i + ii))}>
                                  <Skeleton className="w-full h-4" />
                                </FadeIn>
                              </TableCell>
                            ))}
                          </TableRow>
                        ))
                      }

                      <TableRow className="m-0 transition-colors hover:bg-muted/50 data-[state=selected]:bg-muted rounded-none">
                        <TableCell colSpan={columns.length} className="p-0 pr-0 rounded-none">
                          <WorkflowButtonInvite
                            disabled
                            className={"w-full"}
                          />
                        </TableCell>
                      </TableRow>
                    </>
                  ) : (
                    <>
                      <TableRow>
                        <TableCell colSpan={columns.length} className="h-24 text-center">
                          <div
                            className={"w-full h-full border border-dashed rounded place-content-center border-border"}
                          >
                            <p className="text-xs text-muted-foreground text-center">
                              No results.
                            </p>
                          </div>
                        </TableCell>
                      </TableRow>

                      <TableRow className="m-0 transition-colors hover:bg-muted/50 data-[state=selected]:bg-muted rounded-none">
                        <TableCell colSpan={columns.length} className="p-0 pr-0 rounded-none">
                          <WorkflowButtonInvite
                            disabled
                            className={"w-full"}
                          />
                        </TableCell>
                      </TableRow>
                    </>
                  )}
                </TableBody>
              </Table>
            </div>
          </div>
        </div>
      </div>

      {/** Footer */}
    </div>
  )
}

